/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.KrakenKing;
import OreSpawn.entities.LazerLizard;
import OreSpawn.entities.LightningLizard;
import OreSpawn.entities.Lizard;
import OreSpawn.entities.NastysaurusPrime;
import OreSpawn.entities.Needlenose;
import OreSpawn.entities.Squid;
import OreSpawn.entities.SquidGuard;
import OreSpawn.entities.ThrownBlock;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class LavaLizard
extends EntityLiving {
    public LavaLizard(World w) {
        super(w);
        this.uniquename = "OreSpawn:Lava Lizard";
        this.maxrenderdist = 110;
        this.height = 1.1f;
        this.width = 1.5f;
        this.moveSpeed = 0.3f;
        this.setMaxHealth(50.0f);
        this.setHealth(50.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(10.0f);
        this.movefrequency = 50;
        this.setExperience(55);
        this.canSwim = false;
        this.attackRange = 3.5f;
        this.searchDistance = 32.0f;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.tower_defense_enable = true;
        this.enable_buddy = true;
        this.isImmuneToFire = true;
    }

    public boolean isBuddy(Entity e) {
        return e instanceof LavaLizard;
    }

    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10 && this.world.rand.nextInt(3) == 0) {
            this.searchcounter = this.world.rand.nextInt(4);
            this.targetentity = this.findSomethingToAttack();
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1) {
            if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                this.targetentity.doAttackFrom((Entity)this, 4, this.getAttackDamage());
            } else {
                double cdir = Math.toRadians(this.rotation_yaw);
                double tdir = Math.atan2(this.targetentity.posx - this.posx, this.targetentity.posz - this.posz);
                double ddiff = tdir - cdir;
                while (ddiff > Math.PI) {
                    ddiff -= Math.PI * 2;
                }
                while (ddiff < -Math.PI) {
                    ddiff += Math.PI * 2;
                }
                if (Math.abs(ddiff) < 1.0471975511965976) {
                    this.do_distance_attack(this.targetentity);
                }
            }
        }
        super.doEntityAction(deltaT);
    }

    private void do_distance_attack(Entity victim) {
        if (victim.getHeight() * victim.getWidth() < 0.5f) {
            return;
        }
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f));
        double starty = this.posy + (double)(this.getHeight() * 3.0f / 4.0f);
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f));
        float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
        float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
        float tdiry = (float)Math.atan2(starty - (victim.posy + (double)victim.getHeight()), hdist);
        tdiry = (float)((double)tdiry - 0.15707963267948966);
        ThrownBlock e = (ThrownBlock)this.world.createEntityByName("OreSpawn:ThrownBlock", this.dimension, startx, starty, startz);
        if (e != null) {
            e.init();
            e.setBID(Blocks.lava.blockID);
            e.setIID(this.world.rand.nextInt(15) + 1);
            e.thrower = this;
            e.setAttackDamage(30.0f);
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 2.5f, 0.2f);
            this.world.spawnEntityInWorld((Entity)e);
        }
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.lumptin.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)Blocks.blocktin.blockID, (int)0, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinboots.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinleggings.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinchestplate.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinhelmet.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinpickaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinshovel.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinsword.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.tinhoe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophylavalizard.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof LightningLizard) {
            return false;
        }
        if (e instanceof LavaLizard) {
            return false;
        }
        if (e instanceof LazerLizard) {
            return false;
        }
        if (e instanceof Lizard) {
            return false;
        }
        if (e instanceof Needlenose) {
            return false;
        }
        if (e instanceof NastysaurusPrime) {
            return false;
        }
        if (e.getWidth() * e.getHeight() < 0.53f && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Squid && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Kraken && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof SquidGuard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof KrakenKing && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/LavaLizardtexture.png");
        }
        return this.texture;
    }
}

